/*------------------------------------------------------------------------------*
 * File Name: OriginCSupportEx.c												*
 * Creation: BT & GJL 8/18/03													*
 * Purpose: OriginC Source C file containing OriginCSupportEx.c examples.		*
 * Copyright (c) OriginLab Corp.	2003										*
 * All Rights Reserved															*
 *------------------------------------------------------------------------------*/

#include <Origin.h>

// Declare variables anywhere in code 
void DeclareVariablesAnywhereEx()
{
	vector<double> v1; // Declare at beginning
	v1.SetSize(10);
	for(int ii = 0; ii < 10; ii++) // Declare in for statement (local to block)
	{
		double dii = ii; // Declare in block (local to block)
		v1[ii] = rnd(dii);
	}
	double val = v1[0]; // Declare at end
	printf("%f\n", val);
}

// Declare overloaded functions
double Max(double, double);
int Max(int, int);

void CallOverloadedFunctionsEx()
{
	int ii = Max( 20, 5 );
	double dd = Max( 15.5, 30.0 );
	printf("The Max int is %d\n", ii);
	printf("The Max double is %.1f\n", dd);
}

// Max of doubles
double Max(double d1, double d2)
{
	return ( d1 > d2 ) ? d1 : d2;
}

// Max of ints
int Max(int i1, int i2)
{
	return ( i1 > i2 ) ? i1 : i2;
}

// Pass by reference
void ChangeVals(int in1, int& in2);

void PassByReferenceEx()
{
	int val1 = 5, val2 = 10;
	printf("val1=%3d and val2=%3d\n", val1, val2);
	ChangeVals(val1, val2);
	printf("val1=%3d and val2=%3d\n", val1, val2);
}

// Pass by reference
void ChangeVals(int in1, int& in2)
{
	in1 = in1 + 100;
	in2 = in2 + 100;
	printf("in1 =%3d and in2 =%3d\n", in1, in2); 
}

// Default arguments
int GetVolume(int length, int width = 2, int height = 3);

void DefaultArgumentsEx()
{
	int x = 10, y = 4, z = 5;
	out_int("Volume (10*4*5)=", GetVolume(x, y, z));
	out_int("Volume (10*4*3)=", GetVolume(x, y));
	out_int("Volume (10*2*3)=", GetVolume(x));
}

int GetVolume(int length, int width, int height)
{
	return length * width * height;
}

// Print column names in the active worksheet
void PrintColNamesEx()
{
	Worksheet wks = Project.ActiveLayer(); // Declare worksheet object
	if( wks.IsValid() )
	{
		// wks.Columns is collection of columns
		foreach( Column col in wks.Columns )
		{
			printf("%s\n", col.GetName());
		}
	}
}

// Using keyword. The example assumes that the Book1 and Book2 worksheets exist in the current project. 
void UsingKeywordEx()
{
     Worksheet  wks;
     // wpg is "shorthand" for wks.GetPage()
     using wpg = wks.GetPage();
     
     if(wks.Attach("Book1"))
          out_str(wpg.GetName());
     if(wks.Attach("Book2"))
          out_str(wpg.GetName());
}
